document.addEventListener("DOMContentLoaded", function() {
  // Answer button selection
  document.querySelectorAll('.answer-btn').forEach(btn => {
    btn.addEventListener('click', function() {
      const question = this.dataset.question;
      document.querySelectorAll(`.answer-btn[data-question="${question}"]`).forEach(b => {
        b.classList.remove('selected');
      });
      this.classList.add('selected');
    });
  });

  // Form submission
  const form = document.getElementById('insurance-form');
  const loader = document.querySelector('.loader-container');
  const finalQuestion = document.querySelector('.final-question');
  const quizWrapper = document.querySelector('.insurance-quiz__wrapper');

  form.addEventListener('submit', function(e) {
    e.preventDefault();
    
    const currentInsurance = document.querySelector('[data-question="current_company"]').value;
    
    if (currentInsurance === "Not Insured") {
      // Redirect to homepage if "Not Insured"
      window.location.href = "https://t.zapupdate.com/aff_c?";
    } else {
      // Show loader and hide form
      quizWrapper.style.display = 'none';
      loader.style.display = 'block';
      
      // After 2.5 seconds, show final question
      setTimeout(function() {
        loader.style.display = 'none';
        finalQuestion.style.display = 'block';
      }, 2000);
    }
  });

  // Apply Now button functionality
  document.querySelector('.apply-now-btn')?.addEventListener('click', function() {
    // Collect all form data
    const formData = {
      dui: document.querySelector('.answer-btn.selected[data-question="dui"]')?.dataset.answer,
      vehicle_year: document.querySelector('[data-question="vehicle_year"]').value,
      current_company: document.querySelector('[data-question="current_company"]').value
    };
    
    // Submit to Google Sheets (your existing code)
    const form = document.forms["data-to-google-table"];
    const scriptURL = "YOUR_GOOGLE_SCRIPT_URL";
    
    fetch(scriptURL, { method: "POST", body: new FormData(form) })
      .then(response => {
        // Redirect after submission
        window.location.href = "finish.html";
      })
      .catch(error => console.error('Error!', error.message));
  });
});

document.addEventListener("DOMContentLoaded", function() {
  const form = document.getElementById('insurance-form');
  const loader = document.querySelector('.loader-container');
  const finalQuestion = document.querySelector('.final-question');
  const formContainer = document.querySelector('.form-container');

  form.addEventListener('submit', function(e) {
    e.preventDefault();
    
    const currentInsurance = document.querySelector('[data-question="current_company"]').value;
    
    if (currentInsurance === "Not Insured") {
      window.location.href = "https://t.zapupdate.com/aff_c?";
    } else {
      // Hide the entire form
      form.style.display = 'none';
      // Show loader
      loader.style.display = 'block';
      
      setTimeout(function() {
        // Hide loader
        loader.style.display = 'none';
        // Show final question
        finalQuestion.style.display = 'block';
      }, 2000);
    }
  });

  // Apply Now button functionality
  document.querySelector('.apply-now-btn')?.addEventListener('click', function() {
    // Your form submission logic here
    console.log("Form submitted!");
  });
   // Handle liability option selection
   document.querySelectorAll('.liability-btn').forEach(btn => {
    btn.addEventListener('click', function() {
      // Remove selected class from all options
      document.querySelectorAll('.liability-btn').forEach(b => {
        b.classList.remove('selected');
      });
      
      // Add selected class to clicked button
      this.classList.add('selected');
      
      // Store the selected option (optional)
      const selectedOption = this.dataset.option;
      console.log("Selected option:", selectedOption);
    });
  });
  
  // Update Apply Now button to check selection
  document.querySelector('.apply-now-btn')?.addEventListener('click', function() {
    const selectedOption = document.querySelector('.liability-btn.selected');
    if (!selectedOption) {
      alert('Please select a liability option');
      return;
    }
    
    // Your existing form submission logic
    console.log("Selected liability:", selectedOption.dataset.option);
    // Submit form...
  });

  document.querySelectorAll('.apply-option-btn').forEach(btn => {
    btn.addEventListener('click', function() {
      const option = this.closest('.coverage-option');
      const planType = option.querySelector('h3').textContent;
      const price = option.querySelector('.price-amount').textContent;
      
      console.log("Selected plan:", planType, "Price:", price);
      
      // Add this data to your form submission
      // You'll need to add hidden fields to your form for these values
      document.querySelector('[name="selected_plan"]').value = planType;
      document.querySelector('[name="selected_price"]').value = price;
      
      // Submit your form (use your existing submission logic)
      const form = document.forms["data-to-google-table"];
      const scriptURL = "YOUR_GOOGLE_SCRIPT_URL";
      
      fetch(scriptURL, { method: "POST", body: new FormData(form) })
        .then(response => {
          // Redirect after successful submission
          window.location.href = "thank-you.html";
        })
        .catch(error => console.error('Error!', error.message));
    });
  });
  function getRandomOdd(min, max) {
    let num;
    do {
      num = Math.floor(Math.random() * (max - min + 1)) + min;
    } while (num % 2 === 0); // Keep generating until odd number
    return num;
  }

  // Generate prices
  const option1Price = (getRandomOdd(11, 19) + Math.random()).toFixed(2);
  const option2Price = (getRandomOdd(21, 31) + Math.random()).toFixed(2);
  const option3Price = (getRandomOdd(33, 49) + Math.random()).toFixed(2);

  // Update DOM
  document.querySelectorAll('.price-amount')[0].textContent = `$${option1Price}`;
  document.querySelectorAll('.price-amount')[1].textContent = `$${option2Price}`;
  document.querySelectorAll('.price-amount')[2].textContent = `$${option3Price}`;

  // Store values in hidden fields before submission
  document.querySelectorAll('.apply-option-btn').forEach((btn, index) => {
    btn.addEventListener('click', function() {
      const prices = [option1Price, option2Price, option3Price];
      document.querySelector('[name="selected_price"]').value = prices[index];
      // Your existing form submission logic
    });
  });
});